function labels = image_seg(A, K, sigma_w, sigma_I)

[m,n] = size(A);
N = m*n;
W = zeros(N,N);

for k0 = 1:N
    %k0
    j0 = ceil(k0/m); i0 = k0 - (j0-1)*m;
    for i = max(1, i0-2*sigma_w) : min(m,i0+2*sigma_w)
        for j = max(1, j0-2*sigma_w) : min(n,j0+2*sigma_w)
            k = (j-1)*m+i;
            W(k0,k) = exp(-(A(i0,j0)-A(i,j))^2/(2*sigma_I^2))*exp(-((i-i0)^2+(j-j0)^2)/(2*sigma_w^2));
        end
    end
end

W(1:N+1:end) = 0;
W = (W+W')/2;
W = sparse(W);

dvec_inv = 1./sqrt(sum(W,2));

W_tilde = repmat(dvec_inv, 1, N).*W.*repmat(dvec_inv', N, 1);
W_tilde = (W_tilde+W_tilde')/2;

[V,~] = eigs(W_tilde, K, 'LM', struct('issym', true, 'isreal', true));

U = repmat(dvec_inv, 1, K-1).*V(:,2:K);

labels = kmeans(U, K, 'replicates', 10);

for k = 1:K
    a = zeros(1,N); a(labels==k)=A(labels==k);
    figure; imagesc(reshape(a,m,n)); colormap gray
end