function [X, labels] = simulate_data(dataType)

switch dataType
    
    case 'twoblocks'
        X = [rand(30,2)*0.5; rand(30,2)+0.6];
        labels = [ones(1,30), 2*ones(1,30)];
        
        
    case 'twocircles'
        theta = (0:0.05:2*pi)';
        X1 = 0.5*[cos(theta), sin(theta)];% zeros(length(theta), 8)];
        X2 = 6*X1;
        X = [X1;X2];
        X = X + rand(size(X));
        labels = [ones(1,numel(theta)), 2*ones(1,numel(theta))];
        
        
    case 'threecircles'
        
        theta = (0:0.01:2*pi)';
        X1 = 0.5*[cos(theta), sin(theta)];% zeros(length(theta), 8)];
        X2 = 6*X1;
        X3 = 10*X1;
        X = [X1;X2; X3];
        X = X + 1.15*rand(size(X));
        labels = reshape(repmat(1:3, numel(theta),1),[],1);
        
        
    case 'twogaussians'
        
        n = 100; % number of points in each cluster
        X = [randn(n,2)*0.5 + 1; randn(n,2)*0.5 - 1];
        labels = reshape(repmat(1:2, n, 1), 1, []);
        
        
    case 'threegaussians'
        
        n = 100; % number of points in each cluster
        X = [randn(n,2)*0.5 + 1; randn(n,2)*0.5 - 1; randn(n,2)*0.5 + repmat([-2 2],n,1)];
        labels = reshape(repmat(1:3, n, 1), 1, []);
        
     
    case 'twodensity'
        X = [rand(50,2)*0.1 + 0.45; rand(50,2)];
        labels = [ones(1,30), 2*ones(1,50)];
        
end
