clear
close all
clc

%%  Define matrices
X = [ 1 -1 
      0  1 
      1  0 ]
% or simply X = [1,-1; 0, 1; 1, 0];

% generate a random matrix whose entries are iid Uniform(0,1)
Y = rand(3,3); 

whos

% try common matrix operations

%% Singular value decomposition

% help svd

[U,S,V] = svd(X); % full SVD

[U,S,V] = svd(X, 'econ') % economic SVD 

s = svd(X);  % only the vector of singular values

Y = rand(100,100); % random 100 x 100 matrix 
s = svds(Y,10); % find only a few singular values
[U,S,V] = svds(Y,5); % find only a few singular values and singular vectors

%% matrix norms
% help norm

X_Fnorm = norm(X,'fro') % Frobenius norm
X_2norm = norm(X,2) % 2-norm, or spectral norm

% Note that the matrix nuclear norm is not implemented in MATLAB.
% You can use the following lines to do it.
s = svd(X);
X_nuclear_norm = sum(s);

X_nuclear_norm = sum(svd(X));
%% low rank matrix approximation
k = 2;
X_k = U(:,1:k)*S(1:k,1:k)*V(:,1:k)';
