clear
close all
clc

%% load and display images
load extendedYaleB_crop

person_1 =  matI(:,labels==1);
figure; DisplayImageCollection(reshape(person_1,192,168,[]));

%% PCA
X = matI(:,labels>10)'; % subjects 11, 12, ..., 39
ave = mean(X,1);

figure; imagesc(reshape(ave,192,168,[])); colormap gray; title 'average face'

X_c = X-repmat(ave,size(X,1),1);
[U,S,V] = svds(X_c,50);

s = diag(S);
figure; plot(s, 'b.', 'MarkerSize', 12); title('Singular values')

figure; plot(cumsum(s.^2)/norm(X_c,'fro')^2, 'b.', 'MarkerSize', 12); title('Explained variance')

figure; DisplayImageCollection(reshape(V,192,168,[])); title 'basis'

figure; plot(S(1,1)*U(:,1), S(2,2)*U(:,2), '.', 'MarkerSize', 12); title 'principle coordinates'

%figure; plot3(S(1,1)*U(:,1), S(2,2)*U(:,2), S(3,3)*U(:,3), '.')
%figure; gcplot(U(:,1:3)*S(1:3,1:3), labels(labels<11))