clear
close all
clc

%% generate data
x = -2:0.05:2;
y = x.^2;

X = [x;y;zeros(8,length(x))]';
X = X+0.1*rand(size(X));

figure; plot(X(:,1), X(:,2), 'b.', 'MarkerSize', 14); axis equal

%% principal component analysis

center = mean(X,1); % average of the rows
X_tilde = X - repmat(center, size(X,1), 1);
[U,S,V] = svd(X_tilde,'econ');

figure; plot(diag(S), '.', 'MarkerSize', 10); title 'singular values'

X_3_pc = U(:,1:3)*S(1:3,1:3); 
figure; plot(X_3_pc(:,1), X_3_pc(:,2), '.')

figure; plot3(X_3_pc(:,1), X_3_pc(:,2), X_3_pc(:,3), '.')
%axis equal;
zlim([-1 1])
