clear
close all
clc

%% generate data, no outlier yet
n = 20; % data size
d = 2; % ambient dimension
r = 1; % plane dimension
noiseLevel = 0.05;

X = generate_data(n,d,r,noiseLevel);

figure; plot(X(:,1), X(:,2), 'b.', 'MarkerSize', 14); axis equal

%% principal component analysis

center = mean(X,1); % average of the rows
X_tilde = X - repmat(center, n, 1);
[U,S,V] = svd(X_tilde,'econ');

figure; plot(X_tilde(:,1), X_tilde(:,2), 'b.', 'MarkerSize', 14)
axis equal
hold on

X_1 = U(:,1)*S(1,1)*V(:,1)'; 
plot(X_1(:,1), X_1(:,2), 'r-', 'linewidth', 2)

%% add an outlier
X(n, :) = [2*max(X(:,1)) mean(X(:,2))]; 

center = mean(X,1); % average of the rows
X_tilde = X - repmat(center, n, 1);
[U,S,V] = svd(X_tilde,'econ');

figure; plot(X_tilde(:,1), X_tilde(:,2), 'b.', 'MarkerSize', 14)
axis equal
hold on

X_1 = U(:,1)*S(1,1)*V(:,1)'; 
plot(X_1(:,1), X_1(:,2), 'r-', 'linewidth', 2)
