clear
close all
clc

%% generate data
n = 20; % data size
d = 2; % ambient dimension
r = 1; % plane dimension
noiseLevel = 0.1;

X = generate_data(n,d,r,noiseLevel);

%X(n+1, :) = [1.5*max(X(:,1)) mean(X(:,2))]; %add an outlier

figure; plot(X(:,1), X(:,2), 'b.', 'MarkerSize', 14); %axis equal

%% principal component analysis

center = mean(X,1); % average of the rows
X_tilde = X - repmat(center, n, 1);
% the last line is equivalent to 
% X_tilde = zeros(n,d); % initialization
% for i = 1:n
%     X_tilde(i,:) = X(i,:) - center;
% end
[U,S,V] = svd(X_tilde,'econ');

figure; plot(X_tilde(:,1), X_tilde(:,2), 'b.', 'MarkerSize', 14)
axis equal
hold on

X_1 = U(:,1)*S(1,1)*V(:,1)'; 
plot(X_1(:,1), X_1(:,2), 'r-', 'linewidth', 2)

% for i = 1: n
%     plot([X_tilde(i,1) X_1(i,1)], [X_tilde(i,2) X_1(i,2)], 'k-', 'linewidth', 2)
% end

X_res = U(:,2)*S(2,2)*V(:,2)';
plot(X_res(:,1), X_res(:,2), 'k-', 'linewidth', 2)

%% dimensionality reduction
n = 100;
d = 10;
r = 2;
noiseLevel = 0.1;

X = generate_data(n,d,r,noiseLevel);

center = mean(X,1);
X_tilde = X - repmat(center, n, 1);
[U,S,V] = svd(X_tilde,'econ');

figure; plot(diag(S), 'b--o', 'Markersize', 10); title 'Singular Values'

X_pc = U(:,1:3)*S(1:3,1:3);
figure; plot(X_pc(:,1), X_pc(:,2), 'b.', 'MarkerSize', 12)
axis equal

figure; plot3(X_pc(:,1), X_pc(:,2), X_pc(:,3), 'b.', 'MarkerSize', 12)
zlim([-0.5 0.5]) % set the range of z axis