function Y = kernelPCA(K, k)

% Input:
%    K: nxn kernel matrix
%    k: number of target dimensions
%
% Example
%   load kernelpca_data
%   dists = L2_distance(X', X');
%   dists_sort = sort(dists,2,'ascend');
%   sigma = mean(dists_sort(:, 12));
%   K = exp(-dists.^2/(2*sigma^2)); % gaussian kernel
%   Y = kernelPCA(K, 3);
%   figure; gcplot([Y(:,1), zeros(size(Y,1),1)], labels); 
%   figure; gcplot(Y(:,1:2), labels); axis equal

n = size(K,1);

if nargin<2
    k = 3;
end

K_rowMean = mean(K,1);

K_norm = K - repmat(K_rowMean,n, 1) - repmat(K_rowMean', 1, n) + mean(K_rowMean);

opts = struct();
opts.issym = true;
opts.isreal = true;
K_norm = (K_norm+K_norm')/2;
[U,D] = eigs(K_norm, 3, 'LM', opts);

Y = U(:, 1:k) .* repmat((sqrt(diag(D(1:k,1:k))))', n, 1);
%Y = U(:, 1:k) * sqrt(D(1:k,1:k));