function [Y, stress] = mds(dists, k)

% INPUT
% dists: matrix of pairwise distances
% k: target dimension
%
% EXAMPLE
% load CityDistsData
% [Y, stress] = mds(dists,2);
% figure; plot(Y(:,1), Y(:,2), '*'); axis equal
% text(Y(:,1), Y(:,2), Cities, 'VerticalAlignment', 'bottom', 'HorizontalAlignment', 'left')

if nargin < 2
    k = 2;
end

n = size(dists,1);

dists2 = dists.^2; % squared distances
 
mean_dists2 = mean(dists2,1); % mean squared distances for the data

L = 0.5*(repmat(mean_dists2', 1, n) + repmat(mean_dists2, n, 1) - dists2 - mean(mean_dists2)); 

L = (L+L')/2;

[V,D] = eigs(L,k);

Y = V(:, 1:k) .* repmat((sqrt(diag(D(1:k,1:k))))', n, 1);

if nargout > 1
    
    Y_norms = sum(Y.^2,2);
    dists2_Y = repmat(Y_norms', n, 1) + repmat(Y_norms, 1, n) - (2*Y)*Y';
    stress = sqrt(sum(sum((dists - sqrt(dists2_Y)).^2))/sum(sum(dists2)));
    
    figure;
    plot(dists(:), sqrt(dists2_Y(:)), '.')
    axis equal
    title 'fitted distances vs input distances'

end



