clear
close all
clc; 
warning off all
cd D:\MATLAB\work\hosc\ % Change this working directory to the folder where  
                        % you store hosc toolbox on your own computer.
                        % Also, store the data folder as a subdirectory of
                        % the hosc directory 
                        % Finally, if you are a Mac user, you need to
                        % reverse the direction of \ in lines 5 and 25.                       

%% pick an experiment
pExampleNames = {'threecircles','curvesline','squiggles','sphere_ellipsoid','two_moons','fourcircles'};
dims = [1 1 1 2 1 1];
Ks   = [3 3 4 2 2 2];

fprintf('\n Examples:\n');
for k = 1:length(pExampleNames),
    fprintf('\n [%d] %s',k,pExampleNames{k});
end;
fprintf('\n\n  ');

pExampleIdx = input('Pick an example to run: \n');

eval(['load data\' pExampleNames{pExampleIdx}]);
figure; do_plot_data(X); title 'original data'

%% Compare HOSC with NJW
opts = struct();
opts.eta = [0.1 0.001]; if pExampleIdx==6; opts.eta = [0.1 0.0001]; end
opts.knn = 10;
opts.kernel = 'heat';
[labels_hosc, totalVar_hosc, other]  = hosc_ejs(X,dims(pExampleIdx),Ks(pExampleIdx),opts);
figure; do_plot_data(X, labels_hosc); title 'HOSC output'
totalVar_hosc

opts.type = 'value';
opts.sigma = [0.25, 0.1, 0.075, 0.05, 0.025, 0.01, 0.005, 0.001];
[labels1,totalVar_NJW1] = NJW(X,Ks(pExampleIdx),opts);
figure; do_plot_data(X, labels1); title 'NJW with interval search'
totalVar_NJW1

opts.type = 'local_scaling';
opts.sigma = 5:15;
[labels2,totalVar_NJW2] = NJW(X, Ks(pExampleIdx),opts);
figure; do_plot_data(X, labels2); title 'NJW with local scaling'
totalVar_NJW2
    
