clear
close all
clc
warning off all
cd D:\MATLAB\work\hosc\ % Change this working directory to the folder where  
                        % you store hosc toolbox on your own computer.
                        % Also, store the data folder as a subdirectory of
                        % the hosc directory 
                        % Finally, if you are a Mac user, you need to
                        % reverse the direction of \ in lines 34 and 62.         

%% pick an experiment
pExampleNames = {'threecircles','curvesline','squiggles','simulation'};
dims = [1 1 1];
Ks = [3 3 4];

fprintf('\n Examples:\n');
for k = 1:length(pExampleNames),
    fprintf('\n [%d] %s',k,pExampleNames{k});
end;
fprintf('\n\n  ');

pExampleIdx = input('Pick an example to run: \n');

%%
opts.knn = 10;
opts.eta = [0.1 0.001];
opts.kernel = 'heat';
%%
switch pExampleIdx
    
    case {1,2,3}
        
        eval(['load data\' pExampleNames{pExampleIdx}]);
        
        figure; do_plot_data([X;Y]); title 'given data'
        
        opts.alpha = size(Y,1);
        
        [labels_hosc, degGap, other]  = hosc_ejs([X;Y],dims(pExampleIdx),Ks(pExampleIdx),opts);
        figure; do_plot_data([X;Y], labels_hosc); title 'HOSC output'
        degGap
        
        opts1.type = 'value';
        opts1.sigma = [0.25, 0.1, 0.075, 0.05, 0.025, 0.01, 0.005, 0.001];
        [labels1,degGap1] = NJW_outliers([X;Y],opts.alpha,opts1);
        figure; do_plot_data([X;Y], labels1); title 'NJW with interval search'
        degGap1
        
        opts2.type = 'local_scaling';
        opts2.sigma = 5:15;
        [labels2,degGap2] = NJW_outliers([X;Y],opts.alpha,opts2);
        figure; do_plot_data([X;Y], labels2); title 'NJW with local scaling'
        degGap2
        
    otherwise
        
        for i = 1:3
            
            i
            
            eval(['load data\' pExampleNames{i}]);
            
            opts.alpha = size(Y,1);
            
            TPRs = zeros(1, 100);
            TPR1s = zeros(1, 100);
            TPR2s = zeros(1, 100);
            
            degGap = zeros(1, 100);
            degGap1 = zeros(1, 100);
            degGap2 = zeros(1, 100);
            
            for j = 1:100
                
                j
                
                Y = rand(opts.alpha, 2);
                
                [labels, degGap(j)]  = hosc_ejs([X;Y],dims(i),Ks(i),opts);
                TPRs(j) = sum(labels(size(X,1)+1:end)==0)/size(Y,1);
                
                opts1.type = 'value';
                opts1.sigma = [0.25, 0.1, 0.075, 0.05, 0.025, 0.01, 0.005, 0.001];
                [labels1,degGap1(j)] = NJW_outliers([X;Y],opts.alpha,opts1);
                TPR1s(j) = sum(labels1(size(X,1)+1:end)==0)/size(Y,1);
                
                opts2.type = 'local_scaling';
                opts2.sigma = 5:15;
                [labels2,degGap2(j)] = NJW_outliers([X;Y],opts.alpha,opts2);
                TPR2s(j) = sum(labels2(size(X,1)+1:end)==0)/size(Y,1);
                
            end
            
            [mean(TPRs) mean(TPR1s) mean(TPR2s)]
            %[mean(degGap) mean(degGap1) mean(degGap2)]
            
        end
        
end
