% Khat= kernel_center(K)
%   Centers the kernel matrix so that the mean is at the origin.
% Khat= kernel_center(K, i)
%   Centers the kernel matrix so that the i-th column is at the origin.
%   Same as kernel_center(K, I(i,:)) with I= eye(n);
% Khat= kernel_center(K, weights)
%   Centers the kernel matrix so that the weighted mean is at the origin.
%   weights is a n-vector
% Khat= kernel_center(K, Korigin)
%   Centers to an arbitraty point.
%   Korigin is a (n+1)-vector representing the desired origin:
%     The first n entries are k(x(i),desired_origin),
%     and the last one is k(desired_origin,desired_origin)
% (c) 2008 Stefan Atev
function Khat= kernel_center(K, weights)
    n= size(K, 1);
    if nargin< 2
        % center to mean
        Ksum= sum(K, 1)/ n;
        dK= 0.5* K- repmat(Ksum'- 0.5* sum(Ksum)/ n, [1 n]);
    elseif length(weights)== 1
        % zap column
        i= weights;
        Kp= K(:,i);
        dK= 0.5* K- repmat(Kp- 0.5* Kp(i), [1 n]);
    elseif length(weights)== n
        if size(weights,2)> size(weights,1)
            weights= weights';
        end
        Kp= K* weights;
        dK= 0.5* K- repmat(Kp- 0.5* sum(weights.* Kp), [1 n]);
    elseif length(weights)== (n+1);
        if size(weights,2)> size(weights,1)
            weights= weights';
        end
        Kp= weights(1:n);
        dK= 0.5* K- repmat(Kp- 0.5* weights(n+1), [1 n]);
    end
    Khat= dK+ dK'; % ensure symmetry of output
    