function idx= kernel_kflats(K, d, idx0, options)
    if nargin< 4
        options= struct();
    end
    if ~isfield(options, 'outlier_dist')
        options.outlier_dist= inf;
    end
    if ~isfield(options, 'max_iters')
        options.max_iters= 50;
    end
    n= size(K, 1);
    if numel(idx0)== 1
        m= idx0;
        idx0= floor(rand(n, 1)* m)+ 1;
    else
        m= max(idx0);
    end
    diagK= diag(K);
    idx= idx0;
    for j= 1:options.max_iters
        D= zeros(n, m);
        for i= 1:m
            Ki= K(idx== i, :);
            D(:, i)= kscc_subspace_dist(Ki(:, idx== i), Ki, diagK, d);
        end
        [minD, nidx]= min(D, [], 2);
        nidx(minD> options.outlier_dist)= 0;
        if all(nidx== idx)
            break;
        end
        idx= nidx;        
    end
    