% Special form of kernel_center
% (c) 2008 Stefan Atev
function [Khat, Kcross_hat, Klen_hat]= kernel_shift(K, Kcross, Klen, weights)
    [n, m]= size(Kcross);
    if nargin< 4
        weights= ones(n, 1)/ n;
        Kp= (sum(K, 1)/ n)';
        wKp= sum(Kp)/ n;
        dK= 0.5* K- repmat(Kp- 0.5* wKp, [1 n]);
        wKcross= sum(Kcross, 1)/ n;
    else
        Kp= K* weights;
        wKp= sum(weights.* Kp);
        dK= 0.5* K- repmat(Kp- 0.5* wKp, [1 n]);
        wKcross= weights'* Kcross;
    end
    Khat= dK+ dK'; % ensure symmetry of output
    Kcross_hat= (Kcross- repmat(wKcross, [n 1])- repmat(Kp, [1 m]))+ wKp;
    Klen_hat= (Klen- 2* wKcross')+ wKp;
    