% B= kernel_to_distance(K)
%   Compute pairwise distance matrix B from the symmetric Gram matrix K.
% B= kernel_to_distance(Krow,Kcross,Kcol)
% (c) 2008 Stefan Atev
function B= kernel_to_distance(K, Kcross, Kcol)
    if nargin< 2
        % convert K to a pairwise distance matrix
        n= size(K, 1);
        dK= repmat(diag(K), [1 n])- K;
        B= dK+ dK'; % ensure symmetry of output
    elseif nargin== 3
        % K(Krow) is n-by-n or n-by-1, Kcross is n-by-m, Klen is m-by-m or m-by-1
        % B is n-by-m matrix of distances
        [n, m]= size(Kcross);
        % we only need the diagonals of Krow and Kcol
        if size(K, 2)== n
            Krow= diag(K);
        else
            Krow= K;
        end
        if size(Kcol, 2)== m
            Kcol= diag(Kcol)';
        else
            Kcol= Kcol';
        end
        d1= repmat(Krow, [1 m])- Kcross;
        d2= repmat(Kcol, [n 1])- Kcross;
        B= d1+ d2;
    end
    