% KSCC file kscc_build_gramian.m
% [K, m]= kscc_build_gramian(X, kern, ridx, cidx)
function [K, m, kDiag]= kscc_build_gramian(S, G, ridx, cidx)
    if nargin< 4
        cidx= [];
    end
    if nargin< 3
        ridx= [];
    end
    if ~isa(G, 'function_handle') || isempty(S)
        K= [];
        kDiag= [];
        m= 0;
    else
        % S is a data matrix, process through kernel function
        m= size(S, 1);
        if isempty(cidx) && isempty(ridx)            
            % special case, build full symmetric gramian
            for row= 1:m
                for col= row:m
                    Krc= G(S(row, :), S(col, :));
                    K(row, col)= Krc;
                    K(col, row)= Krc;
                end
            end
            if nargout> 2
                kDiag= diag(K);
            end
        else
            % build partial gramian, this may be slower
            if isempty(cidx)
                cidx= 1:m;
            end
            if isempty(ridx)
                ridx= 1:m;
            end
            rw= numel(ridx);
            cl= numel(cidx);
            K= zeros(rw, cl);
            for rc= 1:rw
                row= ridx(rc);
                for cc= 1:cl
                    col= cidx(cc);
                    Krc= G(S(row, :), S(col, :));
                    K(row, col)= Krc;
                end
            end
            if nargout> 2
                kDiag= zeros(m, 1);
                for j= 1:m
                    pt= S(j, :);
                    kDiag(j)= G(pt, pt);
                end
            end
        end
    end
    