% KSCC file spectral_cluster.m
% (c) 2007,2008 Gilad Lerman and Guangliang Chen
function indices= kscc_cluster(A, K, opts)
    m= size(A, 1);

    indices = zeros(m,1);
    index_sort = 1:m;
    degrees = A* sum(A, 1)';    
    
    numOut= opts.alpha;
    if opts.alpha>0

        [ignored, index_sort] = sort(degrees, 'ascend');
        
        if numOut < 1 % percentage
            numOut = round(m * numOut);
        end
        A = A(index_sort(numOut+1:m),:);
        degrees = A* sum(A,1)';
        m = m - numOut;
        
    end

    if opts.normalizeW

        I0 = find(degrees == 0);
        degrees(I0) = 1;
        A = repmat(1./sqrt(degrees), [1, size(A,2)]).* A;

    end

    A(isnan(A)) = 0;
    if min(size(A))> 200
        [Ui,Sk]= svd_thin_US_rot(A,K*2);
    else
        [Ui, Sk]= svd(A,0);
    end
    rK= min(size(Ui, 2), K);
    if rK< K
        warning('Rank of affinity tensor is lower than number of clusters.');
        K= rK;
    end
    U= Ui(:,1:K);
    
    if opts.normalizeU
        U = normalize(U, 2);
    end
    
    %find initial centers
    tol = 1e-8;
    seeds = zeros(K,K);

    u0 = mean(U,1);
    [um,ind_m] = max(sum((U-repmat(u0,m,1)).^2,2));
    seeds(1,:) = U(ind_m(1),:);

    k = 1;
    U1 = U(sum((U - repmat(seeds(1,:),m,1)).^2,2)>tol,:);
    while k < K && size(U1,1)>0
        [um,ind_m] = max(sum((repmat(U1,1,k)-repmat(reshape(seeds(1:k,:)',[],1)',size(U1,1),1)).^2,2));
        %[um,ind_m] = min(max(U1*seeds(1:k,:)',[],2));
        k = k+1;
        seeds(k,:) = U1(ind_m(1),:);
        U1 = U1(sum((U1 - repmat(seeds(k,:),size(U1,1),1)).^2,2)>tol,:);
    end

    if k<K
        indicesKmeans = ceil(K*rand(m,1));
    else
        indicesKmeans = kmeans(U,[],'start',seeds,'EmptyAction','drop');
    end

    indices(index_sort(numOut+1:end),1) = indicesKmeans;
