% KSCC file kscc_extend.m
% (c) 2008 Stefan Atev
function [nidx, mse]= kscc_extend(K, idx, Ktest, Klen, d)
    ncl= max(idx);
    [n, m]= size(Ktest);
    dist= zeros(m,ncl);
    for cl= 1:ncl
        cidx= find(idx== cl);
        Kc= K(cidx, cidx);
        Kt= Ktest(cidx,:);
        dist(:,cl)= kscc_subspace_dist(Kc, Kt, Klen, d);
    end
    dist= dist';
    [minD,nidx]= min(dist);
    largeDistance= Inf;
    nidx(minD> largeDistance)= 0; % set outliers
    mse= sum(minD(minD<= largeDistance))/ m;
    
    