% KSCC file kernel_menger_curvatures.m
% (c) 2008 Stefan Atev
% compute Menger type curvatures in feature space
function curvatures= kscc_menger_curvatures(S, G, indicesSampledColumns, d, opts)
    if isa(G, 'function_handle')
        m= size(S,1);
    else
        m= size(G, 1);
    end
    
    cols= size(indicesSampledColumns, 2);

    % build an index of which Gramian columns will be needed
    lKcols= sparse(false(m, 1));
    lKcols(indicesSampledColumns(:))= 1;
    
    if all(lKcols)
        % we wil need all columns of the Gramian
        % Note: this does not mean we are sampling all columns of
        % the matricised tensor!
        Kcols= [];
        colMap= [];
    else
        % inverse index for columns; k(xi,xj) is stored in K(i,colMap(j))
        Kcols= find(lKcols);
        colMap= zeros(1, m);
        colMap(lKcols)= 1:numel(Kcols);
    end

    % compute K(i,j)= kern(xi,xj)
    % computation
    if ~isa(G, 'function_handle')
        % G is the full Gramian
        if ~isempty(opts.distanceMatrix)
            if isempty(Kcols)
                B= opts.distanceMatrix;
            else
                B= opts.distanceMatrix(:,lKcols);
            end
        else
            B= [];
        end          
        diagK= diag(G);
        if isempty(Kcols)
            K= G;
        else
            K= G(:,lKcols);
        end
    else
        % S is a data matrix, process through kernel function
        B= [];
        [K, mm, diagK]= kscc_build_gramian(S, G, [], Kcols);
    end

    curvatures = Inf* ones(m, cols);

    if d> 0
        for col= 1:cols
            % computes one full column of MTcurvatures directly

            % fixed indices
            Fidx= indicesSampledColumns(:,col);
            lFidx= sparse(false(m,1));
            lFidx(Fidx)= 1;
            lRidx= ~lFidx;
            Ridx= find(lRidx);

            if isempty(Kcols)
                K_FF= K(lFidx, lFidx);
                K_RF= K(lRidx, lFidx);
                k_RR= diagK(lRidx);
            else
                % Fixed kernel submatrix
                K_FF= K(Fidx, colMap(Fidx));
                % Mixed kernel submatrix
                K_RF= K(Ridx, colMap(Fidx));
                % Diagonal of remainder matrix
                k_RR= diagK(Ridx);
            end

            % compute volume for each Ridx
            [V, L]= eig(K_FF+ 1); % faster than [V, L]= svd(K_FF+ 1) for small matrices
            L= diag(L);
            detK_FF= prod(L);
            % adj(A)= det(A)*inv(A)= det(L)*V*inv(L)*V'
            % the adjoint is a matrix of determinants
            adjK_FF= V* diag(detK_FF./ L)* V';
            K_RF1= K_RF+ 1;
            volumes= (k_RR+ 1)* detK_FF- sum((K_RF1* adjK_FF).* K_RF1, 2);

            % compute edge lengths for each Ridx
            % add 1 to diagonal of pairwise distance matrix so that
            % prod can be used directly
            if isempty(B)
                k_FF= diagK(lFidx);
                dK= k_FF* ones(1, d+ 1)- K_FF; % multiplying by ones is faster than repmat for small d
                B_FF= dK+ dK';
                B_RF= repmat(k_RR, [1 (d+ 1)])+ repmat(k_FF', [(m- d- 1) 1])- 2* K_RF;
            else
                if isempty(Kcols)
                    B_FF= B(lFidx, lFidx);
                    B_RF= B(lRidx, lFidx);
                else
                    B_FF= B(Fidx, colMap(Fidx));
                    B_RF= B(Ridx, colMap(Fidx));
                end
            end
            diams= max(max(B_RF, [], 2), max(B_FF(:)));
            plen= [repmat(prod(eye(d+ 1)+ B_FF), [(m- d- 1) 1]).* B_RF, prod(B_RF, 2)];
            denoms= sum(1./ plen, 2);
            %curvatures(Ridx,col)= volumes.* denoms;
            curvatures(Ridx,col)= diams.* (volumes.* denoms);
        end
    else
        % special case for d== 0, just needs edge norms
        for col= 1:cols
            Fidx= indicesSampledColumns(1,col);
            tidx= sparse(false(m,1));
            tidx(Fidx)= 1;
            Ridx= find(~tidx);
            K_FR= K(Ridx, colMap(Fidx))';
            k_FF= diagK(Fidx);
            k_RR= diagK(Ridx);
            if isempty(B)
                B_FR= kernel_to_distance(k_FF, K_FR, k_RR);
                curvatures(Ridx,col)= B_FR';
            else
                curvatures(Ridx,col)= B(Ridx, colMap(Fidx));
            end
        end
    end

    curvatures = abs(curvatures);
