% KSCC file kscc_mse.m
% (c) 2008 Stefan Atev
% Compute sum of average squared error of each cluster
function mse= kscc_mse(S, G, dim, idx)
    K= max(idx);
    if length(dim)== 1 && K > 1
        dim= dim* ones(K,1);
    end

    mse= 0;
    for c= 1:K
        lCidx= (idx== c);
        Cidx= find(lCidx);
        n= numel(Cidx);
        if n== 0
            continue;
        end
        if ~isa(G, 'function_handle')
            % G is a Gramian
            Kraw= G(lCidx, lCidx);
        else
            Kraw= zeros(n);
            for row= 1:n
                for col= row:n
                    krc= G(S(Cidx(row),:), S(Cidx(col),:));
                    Kraw(row, col)= krc;
                    Kraw(col, row)= krc;
                end
            end
        end
        Kctr= kernel_center(Kraw);
        L= svd(Kctr, 0); % don't care about actual directions
        mseadd= sum(L((dim(c)+1):end))/ n;
        mse= mse+ mseadd;
    end
    mse= sqrt(mse/K);
