% KSCC file kscc_plot_data.m
% (c) 2007,2008 Gilad Lerman and Guangliang Chen
function plotStatus = kscc_plot_data(doPlot,figureTitle,data,markersize,memberships,marks)

if doPlot
    
    D = size(data,2);

    if nargin<5
        
        if nargin<4; markersize = 10; end

        figure
        if D>=3
            plot3(data(:,1),data(:,2),data(:,3),'.','MarkerSize',markersize)
            %axis equal
        elseif D==2
            plot(data(:,1),data(:,2),'.','MarkerSize',markersize)
            %axis equal
        else %% D=1
            plot(data,'.','MarkerSize',markersize)
        end
        title(figureTitle)

    else
        
        if nargin<6
            marks = {'rp','b*','co','ms','gv','k+','yh','x','d'};
        end
        
        K = max(memberships);
        inds_0 = find(memberships==0);

        figure
        hold on
        if D>=3
            for k = 1:K
                inds_k = find(memberships==k);
                plot3(data(inds_k,1), data(inds_k,2), data(inds_k,3), marks{k},'MarkerSize',markersize)
            end
            plot3(data(inds_0,1),data(inds_0,2),data(inds_0,3),'k.','MarkerSize',12)
        elseif D==2
            for k = 1:K
                inds_k = find(memberships==k);
                plot(data(inds_k,1), data(inds_k,2), marks{k},'MarkerSize',markersize)
            end
            plot(data(inds_0,1),data(inds_0,2),'k.','MarkerSize',12)
            %axis equal
        else %% D=1
            for k = 1:K
                inds_k = find(memberships==k);
                plot(inds_k, data(inds_k,1), marks{k},'MarkerSize',markersize)
            end
            plot(inds_0, data(inds_0,1),'k.','MarkerSize',12)
        end
        hold off
        title(figureTitle)

    end
    
    plotStatus = 1;

else
    
    plotStatus = 0;
    
end