% KSCC file kscc_subsampling.m
% (c) 2008 Stefan Atev
function [S, m, G, lSaveCols, lDelCols]= kscc_subsampling(X, G, delta)

    if isa(G, 'function_handle')
        [B, N]= kscc_build_gramian(X, G);
        B= kernel_to_distance(B);
    else
        N= size(G, 1);
        B= kernel_to_distance(G);
    end

    if isempty(delta)
        kdiam= sqrt(max(B(:)));
        delta= 0.005* kdiam;
    end
    
    i= 1;
    prev_i= 1;
    delta2= delta* delta;
    lDelCols= false(N,1);
    remCols= true(N,1);
    while ~isempty(i) && i< N
        remCols(prev_i:i)= 0;
        if ~any(remCols)
            break;
        end
        delPts= (B(i, remCols)<= delta2);
        lDelCols(delPts)= 1;
        prev_i= i;
        i= find(remCols, 1);
    end
    lSaveCols= ~lDelCols;
    if isa(G, 'function_handle')
        S= X(lSaveCols, :);
    else
        G= G(lSaveCols, lSaveCols);
        S= []; % convention used by KSCC to avoid copying around unused matrices
    end
    m= sum(lSaveCols);
end
