% KSCC file kscc_subspace_dist.m
% (c) 2008 Stefan Atev
function dists= kscc_subspace_dist(K_AA, K_AB, k_BB, d)
    [K_AA, K_AB, k_BB]= kernel_shift(K_AA, K_AB, k_BB);
    [V,L]= svd(K_AA);
    effd= min(d, size(V, 2));
    V= V(:,1:effd);
    L= diag(L);
    L= L(1:effd);
    A= V* diag(1./sqrt(L));
    P= A'* K_AB;
    nP= sum(P.* P, 1); % the , 1 is needed if d==1
    dists= k_BB- nP';
    