% Ahat= normalize(A)
%   Normalize all columns of A to unit length.
%   If A is a row or column-vector, normalizes row / column;
% Ahat= normalize(A, dim)
%   Normalize the specified dimension of A to unit length;
%   Ensures that sum(A.^2, dim) will be all ones.
% Ahat= normalize(A, dim, p)
%   Normalize the specified dimension of A to unit p-norm;
%   Ensures that sum(A.^p, dim) will be all ones.
% (c) 2008 Stefan Atev
function Ahat= normalize(A, dim, p)
    if nargin< 3
        p= 2;
    end
    if nargin< 2
        dim= 1; % default is column normalization
        if size(A, 1)== 1
            dim= 2; % row-vector, normalize by row
        end
    end
    
    repA= size(A);
    repA(setdiff(1:length(repA), dim))= 1;
    
    if isinf(p)
        Anorms= max(abs(A), [], dim);
    elseif p== 2
        Anorms= sqrt(sum(A.* A, dim));
    elseif p== 1
        Anorms= sum(abs(A), dim);
    else
        Anorms= sum(abs(A).^p, dim).^(1/p);
    end
    
    zidx= find(Anorms< eps);
    Anorms(zidx)= 1;
    Anorms= 1./ Anorms; % multiply by reciprocal for speed
    Anorms(zidx)= 0;    % make short vectors be zero-norm
    
    Ahat= A.* repmat(Anorms, repA);
    
    