
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% To run this script, the following needs to be done first:
% 1. Download the 'GPCA-voting' package at 
%     http://perception.csl.uiuc.edu/software/GPCA/gpca-voting.tar.gz.
%    The function 'generate_samples.m' is used to creat synthetic data.
% 2. Download the real data used in the paper at 
%    http://www.math.duke.edu/~glchen/mapa_realdata.zip,
%    and save it in a subfolder with the name 'data'.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear;
close all;
clc;

%% pick an experiment
pExampleNames  = {'Artificial_Data','Simulation_Mode','Motion_Segmentation','Face_Clustering'};

fprintf('\n Examples:\n');
for k = 1:length(pExampleNames),
    fprintf('\n [%d] %s',k,pExampleNames{k});
end;
fprintf('\n\n  ');

pExampleIdx = input('Pick an example to run: \n');

%%
switch pExampleNames{pExampleIdx}
    
    case 'Artificial_Data'
        
        % set model parameters
        isaffine = false; %affine subspaces or linear
        D = 3; % ambient dimension
        aprioriSubspaceDimensions = [1 2 1];
        K = numel(aprioriSubspaceDimensions); % number of subspaces
        d_max = max(aprioriSubspaceDimensions);
        noiseLevel = 0.04/sqrt(D);
        groupSizes = 200*ones(1,K); %100*aprioriSubspaceDimensions;
        N = sum(groupSizes); %data size
        
        % creat linear subspaces. The function generate_samples is borrowed
        % from the GPCA-voting package at the following url:
        % http://perception.csl.uiuc.edu/software/GPCA/gpca-voting.tar.gz
        [Xt, aprioriSampleLabels, aprioriGroupBases] = generate_samples(...
            'ambientSpaceDimension', D,...
            'groupSizes', groupSizes,...
            'basisDimensions', aprioriSubspaceDimensions,...
            'noiseLevel', noiseLevel,...
            'noiseStatistic', 'gaussian', ...
            'isAffine', 0,...
            'outlierPercentage', 0, ...
            'minimumSubspaceAngle', pi/6);
        X = Xt'; % Xt is D-by-N, X is N-by-D
        
        % creat affine subspaces
        if isaffine
            randomCenters = random('norm', 0, 1, K, D);
            matCenters = zeros(N,D);
            for k = 1:length(aprioriSubspaceDimensions)
                matCenters(1+sum(groupSizes(1:k-1)): sum(groupSizes(1:k)),:) = repmat(randomCenters(k,:), groupSizes(k), 1);
            end
            X = X + matCenters;
        end
        
        % set mapa parameters
        opts = struct('n0',20*K, 'dmax',d_max, 'Kmax',2*K, 'plotFigs',true, 'showSpectrum', 0);
                
        % apply mapa
        tic; [labels, planeDims, other] = mapa(X,opts); TimeUsed = toc
        MisclassificationRate = clustering_error(labels,aprioriSampleLabels)
        
    case 'Simulation_Mode'
        
        nLoops = 10;

        D = 3
        dims = [1 2 1]
        noiseLevel = 0.04/sqrt(D);
        
        run_simulation_mapa_only(D, dims, noiseLevel, nLoops);
        
    case 'Motion_Segmentation'
        
        dataset = {'kanatani1', 'kanatani2','kanatani3'}; 
        
        for i = 1:3
            
            sequence = i
            eval(['load data/MotionSegmentation/' dataset{i} '/' dataset{i} '_truth']);
            [~, N, F] = size(x);
            z = transpose(reshape(permute(x(1:2,:,:),[1 3 2]),2*F,N)); 
            [U,S] = svds(z-repmat(mean(z,1),N,1),10);
            X = U(:,1:10)*S(1:10,1:10);
            [aprioriSampleLabels, inds] = sort(s); 
            X = X(inds,:); %figure; do_plot_data(X(:,1:3))
            
            opts = struct('dmax',3, 'Kmax',5, 'n0',N, 'plotFigs',true);
            tic; [labels, planeDims, other] = mapa(X,opts); TimeUsed = toc
            planeDims
            estimatedTolerance = other.eps*sqrt(10)
            MisclassificationRate = clustering_error(labels,aprioriSampleLabels)
            
            fprintf('\n')
            
        end
        
    case 'Face_Clustering'
        
        load data/FaceClustering/yaleFacesB
        
%         % faces 5, 8, 10
%         [U, S, V] = svd(I(:, [64*4+1:320 64*7+1:64*8 64*9+1:640]),0);
%         X = V(:,1:10)*S(1:10,1:10); N = size(X,1);
%         opts = struct('dmax',3, 'Kmax',6, 'n0',N, 'plotFigs',true, 'MinNetPts',6, 'nScales',30, 'nPtsPerScale',3);
%         tic; [labels, planeDims, other] = mapa(X,opts); TimeUsed = toc
%         MisclassificationRate = clustering_error(labels,reshape(repmat([1 2 3], 64, 1), 1, []))
        
        % all 10 faces
        [U, S, V] = svd(I,0);
        X = V(:,1:30)*S(1:30,1:30); % 640 points
        figure; do_plot_data(X(:,1:3));
        opts = struct('dmax',3, 'Kmax',15, 'n0',640, 'plotFigs',true);
        tic; [labels, planeDims, other] = mapa(X,opts); TimeUsed = toc
        MisclassificationRate = clustering_error(labels,reshape(repmat(1:10, 64, 1), 1, []))
        
end
